TITLE   'Field Energy of Metal Balls in Glass'			{ exa116.pde }
SELECT     						{ Professional Version }
   errlim=1e-6     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS
   r1=0.03     d0=0.100     r2=0.03     r3=1.0     U2=1.0   	{ Voltage }
   eps0=8.854e-12     eps=7*eps0					{ Glass }
   Er=-dr(U)     Ez=-dz(U)     E=-grad(U)     Em=magnitude(E)
   D=eps*E     Dm=magnitude(D)
   Q1=surf_integral(-normal(D), 'ball1')				{ Charge 1 }
   Q2=surf_integral(-normal(D), 'ball2')  				{ Charge 2 }
   Q=0.5*[ abs(Q1)+ abs(Q2)]					{ Average }
   F1=surf_integral(-0.5*normal(D)*Ez, 'ball1')			{ Force 1 }
   F2=surf_integral(-0.5*normal(D)*Ez, 'ball2')			{ Force 2 }
   W=vol_integral(0.5*Dm*Em)					{ Energy }
EQUATIONS
   div( D)=0
BOUNDARIES
region 'domain'
   start (0,-d0/2-r1)  natural(U)=0 line to (0,-r3)
   natural(U)=0 arc(center=0,0) angle=180  line to (0,d0/2+r2)
   value(U)=U2  arc(center=0,d0/2) angle=-180
   natural(U)=0  line to (0,-d0/2+r1)
   value(U)=0  arc(center=0,-d0/2)  angle=-180 close
feature
   start 'outer' (0,-r3) arc( center=0,0) angle=180
   start 'ball1' (0,-d0/2+r1) arc( center=0,-d0/2) angle=-180
   start 'ball2' (0,d0/2+r2) arc( center=0,d0/2) angle=-180
PLOTS
   vector(D) norm zoom(0,-d0, 2*d0,2*d0)
summary
   report(U2)   report(d0)   report(Q1)   report(Q2)
   report(Q)   report(W)   report(Q*U2/2)
   report(F1)   report(F2)   report((abs(F1)+ abs(F2))/2) as 'F_mean'
END

